---
id: colors
title: Brand Colors
sidebar_position: 1
---

# Brand Colors

## Core / Shared Palette

| Color Name | Hex | RGB | Usage |
|------------|-----|-----|-------|
| Navy | `#2B363B` | 43, 54, 59 | Holdings brand, dark backgrounds, footers |
| Black | `#000000` | 0, 0, 0 | Text, high contrast |
| White | `#FFFFFF` | 255, 255, 255 | Backgrounds, clean space |
| Grey | `#D1D1D1` | 209, 209, 209 | Borders, dividers |
| Grey Light | `#F9F9F9` | 249, 249, 249 | Section backgrounds, cards |
| Grey Dark | `#676767` | 103, 103, 103 | Secondary text, captions |

---

## Brand Variants

Each service division uses a **three-tone system**: Primary, Light (backgrounds/highlights), and Dark (emphasis/hover states).

### Inspectas — Asbestos Consultants

| Color | Hex | RGB |
|-------|-----|-----|
| Compliance Yellow | `#FFCC00` | 255, 204, 0 |
| Yellow Light | `#FFF6D2` | 255, 246, 210 |
| Yellow Dark | `#CCA300` | 204, 163, 0 |

### Inspectas — Fire Safety Services

| Color | Hex | RGB |
|-------|-----|-----|
| Fire Red | `#D2091E` | 210, 9, 30 |
| Red Light | `#FBE6E9` | 251, 230, 233 |
| Red Dark | `#7E0512` | 126, 5, 18 |

### Inspectas — Water Management

| Color | Hex | RGB |
|-------|-----|-----|
| Water Blue | `#0098D4` | 0, 152, 212 |
| Blue Light | `#E5F4FA` | 229, 249, 250 |
| Blue Dark | `#007BAB` | 0, 123, 171 |

### Inspectas — CDM / H&S Consultants

| Color | Hex | RGB |
|-------|-----|-----|
| Compliance Yellow | `#FFCC00` | 255, 204, 0 |
| Yellow Light | `#FFF6D2` | 255, 246, 210 |
| Yellow Dark | `#CCA300` | 204, 163, 0 |

---

## Quick Reference

| Division | Primary | Light | Dark |
|----------|---------|-------|------|
| Asbestos | `#FFCC00` | `#FFF6D2` | `#CCA300` |
| Fire Safety | `#D2091E` | `#FBE6E9` | `#7E0512` |
| Water Management | `#0098D4` | `#E5F4FA` | `#007BAB` |
| CDM / H&S | `#FFCC00` | `#FFF6D2` | `#CCA300` |
| Holdings / Core | `#2B363B` | `#F9F9F9` | `#676767` |

---

## Usage Rules
- Each service division leads with its own primary colour
- Light variants for section backgrounds and subtle highlights
- Dark variants for hover states, emphasis, and contrast
- Navy (`#2B363B`) is the unifying brand colour across all divisions
- The neutral palette (Navy, Grey, Black, White) is shared across all divisions
- Ensure contrast ratios meet WCAG AA standards (4.5:1 for text)
