---
id: seo
title: SEO Guidelines
sidebar_position: 4
---

# SEO Guidelines

Standards for search engine optimisation across all Inspectas websites.

---

## Meta Titles

Every page must have a unique meta title following this format:

```
[Page Topic] — [Division Name]
```

**Examples:**
- `Asbestos Surveys, Testing & Management — Inspectas Asbestos`
- `Fire Risk Assessments — Inspectas Fire Safety Services`
- `Water Management Compliance — Inspectas Water Management`
- `CDM Principal Designer Services — Inspectas CDM`

**Rules:**
- Keep under 60 characters where possible
- Lead with the primary keyword, brand name at the end
- No keyword stuffing — one core topic per title
- Homepage format: `[Division Name] — Inspectas Compliance`

---

## Meta Descriptions

```
[What we do] + [Why choose us / benefit] + [CTA]
```

**Example:**
> UKAS accredited asbestos consultants delivering surveying, training, testing and management. Our no-nonsense, client-friendly approach makes compliance stress-free. Get a free consultation.

**Rules:**
- 140–160 characters
- Include the primary keyword naturally
- End with a call to action where appropriate
- Unique per page — never duplicate across pages

---

## URL Structure

Follow the established pattern across all Inspectas sites:

| Level | Pattern | Example |
|-------|---------|---------|
| Service hub | `/what-we-do/` | `inspectasasbestos.co.uk/what-we-do/` |
| Service page | `/what-we-do/[service-name]/` | `/what-we-do/asbestos-surveying/` |
| Sector hub | `/where-we-work/` | `/where-we-work/` |
| Sector page | `/where-we-work/[sector]/` | `/where-we-work/education/` |
| Info pages | `/about-us/`, `/contact-us/`, `/news/` | — |

**Rules:**
- Lowercase, hyphen-separated (no underscores or spaces)
- Short and descriptive — max 3–4 levels deep
- No dates, IDs, or parameters in service page URLs
- Trailing slash for consistency

---

## Heading Hierarchy

Every page should have a clear heading structure:

| Tag | Usage | Example |
|-----|-------|---------|
| H1 | One per page, contains primary keyword | `Asbestos Consultants and Compliance Partners` |
| H2 | Section headings | `Our Services`, `Why Choose Inspectas` |
| H3 | Sub-sections within H2 blocks | `Asbestos Surveying`, `Air Testing` |
| H4+ | Rarely needed, use sparingly | — |

**Rules:**
- Only one H1 per page
- Don't skip levels (e.g. H1 → H3)
- Headings should read as a logical outline of the page
- Include keywords naturally — don't force them

---

## Primary Keywords by Division

| Division | Primary Keywords |
|----------|-----------------|
| **Inspectas Compliance** | property compliance, compliance consultancy, multi-disciplinary surveyors |
| **Inspectas Asbestos** | asbestos survey, asbestos consultants, asbestos management, asbestos testing, UKAS accredited |
| **Inspectas Fire Safety** | fire risk assessment, fire door survey, fire compartmentation, BAFE SP205, fire compliance |
| **Inspectas Water Management** | legionella risk assessment, water management, water hygiene, legionella testing |
| **Inspectas CDM** | CDM principal designer, construction health and safety, CDM consultant, H&S advisor |

**Rules:**
- Use primary keywords in H1, meta title, and first paragraph
- Use variations and long-tail keywords in body copy
- Write for people first, search engines second
- Don't repeat the same keyword unnaturally

---

## Image SEO

| Attribute | Requirement | Example |
|-----------|-------------|---------|
| File name | Descriptive, hyphenated | `fire-door-inspection-office.jpg` |
| Alt text | Describe the image, include keyword if natural | `Inspectas surveyor inspecting a fire door in an office building` |
| File size | Under 200KB for web (compress before upload) | Use TinyPNG or similar |
| Format | JPEG for photos, PNG for logos/graphics, SVG for icons | — |

---

## Schema Markup

All Inspectas sites should include structured data:

### Required on every site
- **Organization** — company name, logo, contact info, social profiles
- **WebPage** — page title, description, publish/modified dates
- **BreadcrumbList** — navigation path for all pages beyond homepage

### Recommended where relevant
- **LocalBusiness** — for office location pages
- **FAQPage** — for FAQ sections
- **Service** — for individual service pages

---

## Internal Linking

- Every service page should link to related services within the same division
- Cross-link between divisions where relevant (e.g. asbestos survey page links to fire safety for building compliance)
- Use descriptive anchor text — avoid "click here" or "read more"
- Include a clear CTA linking to the contact page on every service page

---

## Technical Checklist

| Item | Standard |
|------|----------|
| Mobile responsive | All pages must pass Google Mobile-Friendly Test |
| Page speed | Aim for 90+ on Google PageSpeed Insights |
| SSL | HTTPS on all sites (already in place) |
| XML sitemap | Auto-generated and submitted to Google Search Console |
| Robots.txt | Allow crawling of all public pages |
| Canonical tags | Set on all pages to prevent duplicate content |
| 404 page | Custom branded 404 with navigation back to key pages |
| Google Search Console | Connected for all 5 domains |
| Google Analytics | Tracking installed on all sites |

---

## Content Guidelines for SEO

- **Minimum word count:** 300 words per service page, 500+ for pillar/hub pages
- **First paragraph:** Include the primary keyword within the first 100 words
- **Readability:** Aim for a Flesch reading score of 50–60 (clear, professional)
- **Updates:** Review and refresh service page content at least every 6 months
- **Blog/news:** Publish at least 2 articles per month across the group for freshness signals
- **Avoid:** Duplicate content across division sites — each site should have unique copy
