---
id: typography
title: Typography
sidebar_position: 2
---

import Head from '@docusaurus/Head';

<Head>
  <link href="https://fonts.googleapis.com/css2?family=Nunito+Sans:ital,wght@0,400;0,500;0,600;0,700;1,400&display=swap" rel="stylesheet" />
</Head>

# Typography

## Primary Typeface: Nunito Sans
**Source:** Google Fonts
**Usage:** Headlines, body copy, UI text — used across website and brand materials

<a href="https://fonts.google.com/specimen/Nunito+Sans" target="_blank" rel="noopener noreferrer" className="button button--primary button--sm margin-bottom--lg">Download from Google Fonts</a>

---

## Live Preview

<div style={{fontFamily: "'Nunito Sans', sans-serif", border: '1px solid #e0e0e0', borderRadius: '8px', padding: '2rem', marginBottom: '2rem'}}>

<p style={{fontWeight: 700, fontSize: '42px', margin: '0 0 0.25rem', lineHeight: 1.2}}>Heading One — Bold 700</p>
<p style={{fontWeight: 600, fontSize: '30px', margin: '0 0 0.25rem', lineHeight: 1.3}}>Heading Two — Semi-Bold 600</p>
<p style={{fontWeight: 500, fontSize: '23px', margin: '0 0 0.25rem', lineHeight: 1.3}}>Heading Three — Medium 500</p>
<p style={{fontWeight: 400, fontSize: '17px', margin: '0 0 0.25rem', lineHeight: 1.6}}>Body text — Regular 400. Inspectas Compliance is a multi-disciplinary property compliance consultancy providing fully accredited surveyor services across the UK.</p>
<p style={{fontWeight: 400, fontSize: '13px', margin: '0', lineHeight: 1.5, color: '#666'}}>Caption text — Regular 400, 13px. Labels, footnotes and supporting information.</p>

</div>

<div style={{fontFamily: "'Nunito Sans', sans-serif", border: '1px solid #e0e0e0', borderRadius: '8px', padding: '2rem', marginBottom: '2rem'}}>

<p style={{fontSize: '28px', fontWeight: 400, margin: '0 0 0.5rem', letterSpacing: '1px'}}>A B C D E F G H I J K L M N O P Q R S T U V W X Y Z</p>
<p style={{fontSize: '28px', fontWeight: 400, margin: '0 0 0.5rem', letterSpacing: '1px'}}>a b c d e f g h i j k l m n o p q r s t u v w x y z</p>
<p style={{fontSize: '28px', fontWeight: 400, margin: '0', letterSpacing: '1px'}}>0 1 2 3 4 5 6 7 8 9 ! @ £ & ? %</p>

</div>

---

## Fallback Fonts

When Nunito Sans is unavailable — such as in email clients, internal documents, or third-party platforms — use the following system fonts in order of preference. No installation required, they come pre-installed on all major operating systems.

### 1. Helvetica Neue
**Available on:** macOS, iOS
**Why:** Closest match to Nunito Sans in weight and proportion. Clean, professional, and widely regarded as a design standard.

<div style={{fontFamily: "'Helvetica Neue', sans-serif", border: '1px solid #e0e0e0', borderRadius: '8px', padding: '2rem', marginBottom: '2rem'}}>
<p style={{fontWeight: 700, fontSize: '32px', margin: '0 0 0.25rem', lineHeight: 1.2}}>Heading — Bold</p>
<p style={{fontWeight: 400, fontSize: '17px', margin: '0 0 0.25rem', lineHeight: 1.6}}>Body text. Inspectas Compliance is a multi-disciplinary property compliance consultancy providing fully accredited surveyor services across the UK.</p>
<p style={{fontSize: '24px', fontWeight: 400, margin: '0', letterSpacing: '1px'}}>A B C D E F G H I J K L M a b c d e f g h i j k l m 0 1 2 3 4 5 6 7 8 9</p>
</div>

### 2. Arial
**Available on:** Windows, macOS, Linux, iOS, Android
**Why:** Universal availability. Renders consistently everywhere — the safest fallback.

<div style={{fontFamily: "Arial, sans-serif", border: '1px solid #e0e0e0', borderRadius: '8px', padding: '2rem', marginBottom: '2rem'}}>
<p style={{fontWeight: 700, fontSize: '32px', margin: '0 0 0.25rem', lineHeight: 1.2}}>Heading — Bold</p>
<p style={{fontWeight: 400, fontSize: '17px', margin: '0 0 0.25rem', lineHeight: 1.6}}>Body text. Inspectas Compliance is a multi-disciplinary property compliance consultancy providing fully accredited surveyor services across the UK.</p>
<p style={{fontSize: '24px', fontWeight: 400, margin: '0', letterSpacing: '1px'}}>A B C D E F G H I J K L M a b c d e f g h i j k l m 0 1 2 3 4 5 6 7 8 9</p>
</div>

### 3. Segoe UI
**Available on:** Windows
**Why:** The native Windows system font. Clean and modern, good for internal Microsoft Office documents and Windows applications.

<div style={{fontFamily: "'Segoe UI', sans-serif", border: '1px solid #e0e0e0', borderRadius: '8px', padding: '2rem', marginBottom: '2rem'}}>
<p style={{fontWeight: 700, fontSize: '32px', margin: '0 0 0.25rem', lineHeight: 1.2}}>Heading — Bold</p>
<p style={{fontWeight: 400, fontSize: '17px', margin: '0 0 0.25rem', lineHeight: 1.6}}>Body text. Inspectas Compliance is a multi-disciplinary property compliance consultancy providing fully accredited surveyor services across the UK.</p>
<p style={{fontSize: '24px', fontWeight: 400, margin: '0', letterSpacing: '1px'}}>A B C D E F G H I J K L M a b c d e f g h i j k l m 0 1 2 3 4 5 6 7 8 9</p>
</div>

---

## Type Scale

| Element | Weight | Suggested Size | Usage |
|---------|--------|---------------|-------|
| H1 | Bold (700) | 36-48px | Page titles, hero text |
| H2 | Semi-Bold (600) | 28-32px | Section headers |
| H3 | Medium (500) | 22-24px | Sub-sections |
| Body | Regular (400) | 16-18px | Paragraphs, general content |
| Caption | Regular (400) | 12-14px | Labels, footnotes |

## Typography Rules
- Never stretch or distort typefaces
- Maintain consistent hierarchy across all materials
- Minimum body text size: 16px (web), 12pt (print)
- Use Nunito Sans across both digital and print where possible
- Fallback stack: `'Nunito Sans', 'Helvetica Neue', Arial, 'Segoe UI', sans-serif`
